require([
    "esri/config",
    "esri/Map", 
    "esri/views/MapView",

    // add 
    "esri/layers/FeatureLayer",

    // add
    "esri/widgets/Legend",
    "esri/widgets/ScaleBar",
    "esri/widgets/Home",
    "esri/widgets/BasemapGallery",
    "esri/widgets/BasemapToggle",

    // add
    "esri/widgets/LayerList"

], function (esriConfig,Map, MapView, FeatureLayer, Legend, ScaleBar, Home, BasemapGallery, LayerList, BasemapToggle) {

esriConfig.apiKey = "AAPKae1d252c61b646f48faf94b3902347dbWgpA1XT7RovKU3YdvdKPKuO7a9sF2wKe75nBuPTJj0SWE4LR5I6_Qpx8qRj96_Ef";

const map = new Map({
 basemap: "arcgis-light-gray" // Basemap layer service
});



const view = new MapView({
 map: map,
 padding: {
    top: 50,
    bottom: 0
  },
 center: [144.27908, -36.75597], // Longitude, latitude
 zoom:12, // Zoom level
 container: "viewDiv" // Div element
});

view.constraints = {
    // geometry: { // Constrain lateral movement to Lower Manhattan
    //   type: "extent",
    //   xmin: 144.06458,
    //   ymin:  -36.66476,
    //   xmax: 144.44881,
    //   ymax:  -36.86244
    // },
    minScale: 300000, // User cannot zoom out beyond a scale of 1:500,000
    maxScale: 5000, // User can overzoom tiles
    rotationEnabled: false // Disables map rotation
  };

 

// add polygon class styles
const less800 = {
    type: "simple-fill", // autocasts as new SimpleFillSymbol()
    color: "#810f7c",
    style: "solid",
    outline: {
      width: 0.2,
      color: [255, 255, 255, 0.5]
    }
  };

  const less2000 = {
    type: "simple-fill", // autocasts as new SimpleFillSymbol()
    color: "#8856a7",
    style: "solid",
    outline: {
      width: 0.2,
      color: [255, 255, 255, 0.5]
    }
  };

  const less4000 = {
    type: "simple-fill", // autocasts as new SimpleFillSymbol()
    color: "#8c96c6",
    style: "solid",
    outline: {
      width: 0.2,
      color: [255, 255, 255, 0.5]
    }
  };

  const less6000 = {
    type: "simple-fill", // autocasts as new SimpleFillSymbol()
    color: "#b3cde3",
    style: "solid",
    outline: {
      width: 0.2,
      color: [255, 255, 255, 0.5]
    }
  };

  const more6000 = {
    type: "simple-fill", // autocasts as new SimpleFillSymbol()
    color: "#edf8fb",
    style: "solid",
    outline: {
      width: 0.2,
      color: [255, 255, 255, 0.5]
    }
  };

  const propAttribute = {
    type: "class-breaks", // autocasts as new ClassBreaksRenderer()
    field: "AREA_HA", // total number of adults (25+) with a college degree
    // normalizationField: "EDUCBASECY", // total number of adults 25+
    legendOptions:{
        title: "Lot Size Category"
    },
    classBreakInfos: [
        {
          minValue: 0,
          maxValue: 0.08,
          symbol: less800,
          label: "0-800m2" // label for symbol in legend
        },
        {
          minValue: 0.08,
          maxValue: 2.0,
          symbol: less2000,
          label: "800-2000m2" // label for symbol in legend
        },
        {
          minValue: 2.0,
          maxValue: 4.0,
          symbol: less4000,
          label: "2000-4000m2" // label for symbol in legend
        },
        {
          minValue: 4.0,
          maxValue: 6.0,
          symbol: less6000,
          label: "4000-6000m2" // label for symbol in legend
        },
        {
          minValue: 6.0,
          maxValue: 10000000,
          symbol: more6000,
          label: "> 6000m2" // label for symbol in legend
        }
      ],
    defaultSymbol: {
      type: "simple-fill", // autocasts as new SimpleFillSymbol()
      color: "black",
      style: "backward-diagonal",
      outline: {
        width: 0.5,
        color: [50, 50, 50, 0.6]
      }
    },
    defaultLabel: "no data" // legend label for features that don't match a class break
  };

  const propLayer = new FeatureLayer({
    title: "Lot Sizes",
    url: "https://services7.arcgis.com/BUhJcXh0FU0AhCAZ/arcgis/rest/services/property/FeatureServer/0",
    renderer: propAttribute,
    // labelingInfo: [boundLabel]
});

map.add(propLayer);

propAttribute.legendOptions = {
    title: "NA"
    };
    
propLayer.visible = false;



//   const townAttribute = {
//         type: "simple",  // autocasts as new SimpleRenderer()
//         symbol: {
//             type: "simple-marker",  // autocasts as new SimpleFillSymbol()
//             color: [ 255, 128, 0, 0.5 ],
//             outline: {  // autocasts as new SimpleLineSymbol()
//             width: 1,
//             color: "white"
//             }
//         }
//         };

// add land use class styles
const residentialLand = {
    type: "simple-fill", // autocasts as new SimpleLineSymbol()
    color: [206,206,206,0.7],
    outline: {  // autocasts as new SimpleLineSymbol()
        width: 0.1,
        color: "#ffffff"
        },
    style: "solid"
};

const conservationLand = {
    type: "simple-fill", // autocasts as new SimpleLineSymbol()
    color: [181,196,180,0.7],
    outline: {  // autocasts as new SimpleLineSymbol()
        width: 0.1,
        color: "#ffffff"
        },
    style: "solid"
};

const openSpaceLand = {
    type: "simple-fill", // autocasts as new SimpleLineSymbol()
    color: [211,229,210,0.7],
    outline: {  // autocasts as new SimpleLineSymbol()
        width: 0.1,
        color: "#ffffff"
        },
    style: "solid"
};

const otherLand = {
    type: "simple-fill", // autocasts as new SimpleLineSymbol()
    color: [255,255,255,0],
    outline: {  // autocasts as new SimpleLineSymbol()
        width: 0,
        color: "#ffffff"
        },
    style: "solid"
};

const landAttribute = {
    type: "unique-value", // autocasts as new UniqueValueRenderer()
    legendOptions:{
        title: "Land Use Types"
    },   
    field: "CATEGORY",
    uniqueValueInfos: [
        {
          value: "Residential", // code for interstates/freeways
          symbol: residentialLand,
          label: "Residential" // used in the legend to describe features with this symbol
        },
        {
          value: "Conservation", // code for interstates/freeways
          symbol: conservationLand,
          label: "Conservation" // used in the legend to describe features with this symbol
        },
        {
          value: "Open Space", // code for interstates/freeways
          symbol: openSpaceLand,
          label: "Green Space" // used in the legend to describe features with this symbol
        }
      ],
    defaultSymbol: otherLand, // used to visualize all features not matching specified types
    defaultLabel: "Not Classified" //  used in the legend for all other types not specified
  };

  const landLayer = new FeatureLayer({
    title: "Land Use",
    url: "https://services7.arcgis.com/BUhJcXh0FU0AhCAZ/arcgis/rest/services/landuse/FeatureServer/0",
    renderer: landAttribute,
    // labelingInfo: [boundLabel]
});

map.add(landLayer);

landAttribute.legendOptions = {
    title: "NA"
    };
    
landLayer.visible = true; 


// add line class styles
const freeWay = {
    type: "simple-line", // autocasts as new SimpleLineSymbol()
    color: "#383B39",
    width: 3,
    style: "solid"
  };
  
  // Symbol for arterial roads
  const arterialRoad = {
    type: "simple-line", // autocasts as new SimpleLineSymbol()
    color: "#383B39",
    width: 2,
    style: "solid"
  };

  const subArterialRoad = {
    type: "simple-line", // autocasts as new SimpleLineSymbol()
    color: "#383B39",
    width: 1,
    style: "solid"
  };
  
  // Symbol for other major highways
  const otherSym = {
    type: "simple-line", // autocasts as new SimpleLineSymbol()
    color: "#383B39",
    width: 0.5,
    style: "solid"
  };

 
  const roadAttribute = {
    type: "unique-value", // autocasts as new UniqueValueRenderer()
    legendOptions:{
        title: "Road Classes"
    },   
    field: "CAT_ROAD",
    uniqueValueInfos: [
        {
          value: "Freeway", // code for interstates/freeways
          symbol: freeWay,
          label: "Freeway" // used in the legend to describe features with this symbol
        },
        {
          value: "Arterial", // code for U.S. highways
          symbol: arterialRoad,
          label: "Arterial Road" // used in the legend to describe features with this symbol
        },
        {
          value: "Sub-Arterial", // code for U.S. highways
          symbol: subArterialRoad,
          label: "Sub-Arterial Road" // used in the legend to describe features with this symbol
        }
      ],
    defaultSymbol: otherSym, // used to visualize all features not matching specified types
    defaultLabel: "Other" //  used in the legend for all other types not specified
  };

  const roadLayer = new FeatureLayer({
    title: "Road Hierarchy",
    url: "https://services7.arcgis.com/BUhJcXh0FU0AhCAZ/arcgis/rest/services/road/FeatureServer/0",
    renderer: roadAttribute,
    // labelingInfo: [boundLabel]
});

map.add(roadLayer);

roadAttribute.legendOptions = {
    title: "NA"
    };
    
roadLayer.visible = false; 

// add point
const townAttribute = {
type: "unique-value",  // autocasts as new UniqueValueRenderer()
legendOptions:{
    title: "Township Hierarchy"
},
field: "URB_TYPE",
defaultSymbol: { type: "simple-marker" },
defaultLabel: "Others",  // autocasts as new SimpleFillSymbol()
uniqueValueInfos: [{
    // All features with value of "North" will be blue
    value: "Activity Centre",
    symbol: {
    type: "simple-marker",  // autocasts as new SimplemarkerSymbol()
    color: [178,39,193,0.5],
    size: 16,
    outline: {
        width: 1,
        color: "white"
    }
    }
}, {
    // All features with value of "East" will be green
    value: "Neighbourhood Activity Centre",
    symbol: {
    type: "simple-marker",  // autocasts as new SimplemarkerSymbol()
    color: [239,77,31,0.5],
    size: 14,
    outline: {
        width: 1,
        color: "white"
    }   
    }
}, {
    // All features with value of "South" will be red
    value: "Local Centre",
    symbol: {
    type: "simple-marker",  // autocasts as new SimplemarkerSymbol()
    color: [0,0,0,0.5],
    size: 11,
    outline: {
        width: 1,
        color: "white"
    }  
    }
}],
}

    // const townLabel = {
    //     symbol: {
    //     type: "text",
    //     color: "#545454",
    //     haloColor: "#FFFFFF",
    //     haloSize: "2px",
    //     font: {
    //         size: "12px",
    //         family: "Montserrat",
    //         style: "italic",
    //         weight: "normal"
    //     }
    //     },

    //     labelPlacement: "above-center",
    //     labelExpressionInfo: {
    //     expression: "$feature.NAME"
    //     }
    // };

    const townLayer = new FeatureLayer({
        title: "Urban Centres",
        url: "https://services7.arcgis.com/BUhJcXh0FU0AhCAZ/arcgis/rest/services/town/FeatureServer/0",
        renderer: townAttribute,
        // labelingInfo: [townLabel]
    });

map.add(townLayer);
townAttribute.legendOptions = {
title: "Class"
};

townLayer.visible = false;


// ADD POLYGON
const boundAttribute = {
        type: "simple",  // autocasts as new SimpleRenderer()
        label: "Urban Boundary",
        symbol: {
            type: "simple-fill",  // autocasts as new SimpleFillSymbol()
            color: [ 255, 128, 0, 0 ],
            outline: {  // autocasts as new SimpleLineSymbol()
            width: 1.5,
            color: "#e41a1c"
            }
        }
    };

    // const boundLabel = {
    //     symbol: {
    //     type: "text",
    //     color: "#545454",
    //     haloColor: "#FFFFFF",
    //     haloSize: "2px",
    //     font: {
    //         size: "12px",
    //         family: "Montserrat",
    //         style: "italic",
    //         weight: "normal"
    //     }
    //     },

    //     labelPlacement: "above-center",
    //     labelExpressionInfo: {
    //     expression: "$feature.NAME"
    //     }
    // };

    const boundLayer = new FeatureLayer({
        title: "Townships Boundary",
        url: "https://services7.arcgis.com/BUhJcXh0FU0AhCAZ/arcgis/rest/services/boundary/FeatureServer/0",
        renderer: boundAttribute,
        // labelingInfo: [boundLabel]
    });

map.add(boundLayer);

boundAttribute.legendOptions = {
title: "NA"
};

boundLayer.visible = true;


//   // add one point layer to map
//   const townAttribute = new FeatureLayer({
//         url: "https://services7.arcgis.com/BUhJcXh0FU0AhCAZ/arcgis/rest/services/town/FeatureServer/0"
//     });

//   map.add(townAttribute);


// add a legend to map
  const legend = new Legend ({
        view: view,
        title: "DRAWING KEY",
        layerInfos: [{
            layer: townLayer
        },{
            layer: boundLayer
        },{
            layer: propLayer
        },{
            layer: roadLayer
        },{
            layer: landLayer
        }
    ]
    });
  view.ui.add(legend, "top-right");

// add a scale bar to map
  const scalebar = new ScaleBar({
    view: view,
    unit: "metric",
    style: "ruler"
});
    view.ui.add(scalebar, "bottom-left");


    var layerList = new LayerList({
    view: view
    });

    // this position controls base map position
    view.ui.add(layerList, "bottom-right"
    );

// Map widgets
var home = new Home({
    view: view
    });
    view.ui.add(home, "top-left");

var basemapToggle = new BasemapToggle({
    view: view,
    secondBasemap: "satellite"
    });
    // this position controls layers position
    view.ui.add(basemapToggle, "top-left"); 


// let basemapGallery = new BasemapGallery({
//     view: view
//   });
//   // Add widget to the top right corner of the view
//   view.ui.add(basemapGallery, {
//     position: "top-right"
//   });



});

